IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Turno_Validar') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Turno_Validar
END
GO

CREATE  FUNCTION [dbo].[CF_Turno_Validar](@pId_Cliente INT, @pId_Turno BIGINT, @pId_Sector INT, @pCategoria CHAR(1) )
RETURNS VARCHAR(5000)
AS
BEGIN


DECLARE @Respuesta				VARCHAR(5000) 
DECLARE @Fecha					DATETIME
DECLARE @Id_Recurso				INT 
DECLARE @Duracion_Turno			SMALLINT
DECLARE @Horas_Anticipacion		DECIMAL(8,2)
DECLARE @Cupo_Min_Indiv			INT
DECLARE @Cupo_Max_Compartido	INT
DECLARE @Cupo_Max_Indiv			INT
DECLARE @Turno_previo			BIGINT
DECLARE @Minutos_Ant_Oport		INT
DECLARE @Minutos_Post_Oport		INT
DECLARE @Id_Sector				SMALLINT
DECLARE @Fecha_Reserva_Previa	DATETIME
DECLARE @Dia_De_La_Semana		VARCHAR(50)
DECLARE @Hora_Turno				DATETIME
DECLARE @Id_Sector_Deseado		SMALLINT
DECLARE @Turno_previo_acomp     SMALLINT
DECLARE @Flag_Asistencia		TINYINT
DECLARE @Horas_Asistencia		INT
DECLARE @Entrada				INT
DECLARE @Socio					VARCHAR(500)
--===========================================================================================

IF EXISTS ( SELECT * FROM sysobjects 
			WHERE 
			id = object_id(N'dbo.CF_Turno_Validar_') 
			AND type = 'FN')
BEGIN
	/*Si existe la función personalizada CF_Turno_Validar_ utiliza esa*/
    SET @Respuesta = (dbo.CF_Turno_Validar_(@pId_Cliente, @pId_Turno,@pId_Sector,@pCategoria))
    RETURN ISNULL(@Respuesta, '')
END

--===========================================================================================

SELECT	@Id_Recurso = ISNULL(Id_Recurso, 0),
		@Fecha		= Fecha
FROM CRM_Turnos 
WHERE 
Id_Turno = @pId_Turno

SET @Dia_De_La_Semana	= DATENAME(WEEKDAY, @Fecha) --Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday o Lunes, Martes, Miercoles, Jueves, Viernes, Sabado, Domingo
SET @Hora_Turno			= CONVERT(DATETIME, CONVERT(VARCHAR(10), @Fecha, 108))

--===========================================================================================

SELECT @Id_Sector_Deseado = ISNULL(Id_Sector, 0),
	   @Flag_Asistencia   = ISNULL(Flag_Asistencia,0),
	   @Horas_Asistencia  = ISNULL(Horas_Asistencia,0)
FROM Empresas_Sedes_Sec_Recursos
WHERE
Id_Recurso = @Id_Recurso

--===========================================================================================

SELECT @Socio = Razon_Social FROM Clientes WHERE Id_Cliente = @pId_Cliente

--===========================================================================================

IF(@Id_Recurso > 0)
BEGIN

	--===========================================================================================
	
	SELECT	@Duracion_Turno			= ISNULL(Frecuencia, 0),
			@Horas_Anticipacion		= ISNULL(Horas_Anticipacion, 0),
			@Cupo_Min_Indiv			= ISNULL(Cupo_Min_Indiv, 0),
			@Cupo_Max_Compartido	= ISNULL(Cupo_Max_Compartido, 0),
			@Cupo_Max_Indiv			= ISNULL(Cupo_Max_Indiv, 0),
			@Minutos_Ant_Oport		= ISNULL(Minutos_Ant_Oport, 0),
			@Minutos_Post_Oport		= ISNULL(Minutos_Post_Oport, 0)
	FROM Empresas_Sedes_Sec_Recuros_Horarios 
	WHERE 
	Activo = 1
	AND Id_Recurso = @Id_Recurso
	AND (	(ISNULL(Lunes, 0) = 1  AND (@Dia_De_La_Semana = 'Monday'  OR  @Dia_De_La_Semana = 'Lunes'))  OR
			(ISNULL(Martes, 0) = 1 AND (@Dia_De_La_Semana = 'Tuesday' OR  @Dia_De_La_Semana = 'Martes')) OR
			(ISNULL(Miercoles, 0) = 1 AND (@Dia_De_La_Semana = 'Wednesday' OR @Dia_De_La_Semana = 'Miercoles')) OR
			(ISNULL(Jueves, 0) = 1  AND (@Dia_De_La_Semana = 'Thursday' OR  @Dia_De_La_Semana = 'Jueves')) OR
			(ISNULL(Viernes, 0) = 1 AND (@Dia_De_La_Semana = 'Friday' OR @Dia_De_La_Semana = 'Viernes')) OR
			(ISNULL(Sabado, 0) = 1  AND (@Dia_De_La_Semana = 'Saturday'  OR @Dia_De_La_Semana = 'Sabado')) OR
			(ISNULL(Domingo, 0) = 1 AND (@Dia_De_La_Semana = 'Sunday' OR @Dia_De_La_Semana = 'Domingo'))
		)
	AND Hora_Inicio <= @Hora_Turno
	AND Hora_Fin >= @Hora_Turno
	
	--===========================================================================================
	
	/*Revisa si tiene un turno reservado para el mismo sector a la misma hora que solicita el nuevo */
	SET @Turno_previo = (SELECT MIN(T.Id_Turno)
						FROM CRM_Turnos T 
						WHERE 
						T.Id_Cliente = @pId_Cliente 
						AND Fecha = @Fecha
						)
						
	IF(@Turno_previo > 0)
	BEGIN
		SET @Respuesta = 'Ya posee una reserva para el mismo dia y horario.'
		RETURN @Respuesta
	END
						
	--===========================================================================================
						
	IF (@Minutos_Ant_Oport <> 0 OR @Minutos_Post_Oport <> 0) 
		AND GETDATE() >= DATEADD(MINUTE, @Minutos_Ant_Oport*-1, @Fecha) 
		AND GETDATE() <= DATEADD(MINUTE, @Minutos_Post_Oport, @Fecha)
	BEGIN
		SET @Respuesta = ''
		RETURN @Respuesta
	END

	--===========================================================================================
	
	IF DATEADD(hh, @Horas_Anticipacion, GETDATE()) > @Fecha 
	BEGIN
		SET @Respuesta = 'No es posible tomar la reserva con esta anticipación'
		RETURN @Respuesta
	END
	
	--===========================================================================================
	
	--busqueda de turnos previos en misma SEDE.
	SET @Turno_previo = (SELECT MIN(T.Id_Turno) --COUNT(*) 
						FROM CRM_Turnos T 
						WHERE 
						T.Id_Cliente = @pId_Cliente 
						AND GETDATE() <= DATEADD(MINUTE, @Duracion_Turno, @Fecha)
						AND Id_Recurso IN (SELECT Id_Recurso FROM Empresas_Sedes_Sec_Recursos WHERE Id_Sector = @Id_Sector_Deseado))

	IF (@Turno_previo = 0)
	BEGIN
		SET @Turno_previo = (SELECT MIN(T.Id_Turno) --COUNT(*) 
							FROM CRM_Turnos T, CRM_Turnos_Clientes TC 
							WHERE 
							TC.Id_Turno = T.Id_Turno
							AND TC.Id_Cliente = @pId_Cliente 
							AND GETDATE() <= DATEADD(MINUTE, @Duracion_Turno, @Fecha)
							AND Id_Recurso IN (SELECT Id_Recurso FROM Empresas_Sedes_Sec_Recursos WHERE Id_Sector = @Id_Sector_Deseado))
	END

	IF (@Turno_previo = 0)
	BEGIN
		SET @Respuesta = ''
	END
	ELSE
	BEGIN
		SELECT
		@Fecha_Reserva_Previa = Fecha
		FROM CRM_Turnos
		WHERE
		Id_Turno = @Turno_previo
		
		SET @Respuesta = 'Ya posee una reserva previa el: '+  CONVERT(VARCHAR(10), @Fecha_Reserva_Previa, 103) + ' ' + CONVERT(VARCHAR(5), @Fecha_Reserva_Previa, 114) 
	END


	--==============================Verifica por recurso el ultimo ingreso (en horas) que el socio ingreso al club para poder tomar el turno ============================
	IF (@Flag_Asistencia = 1 AND @Horas_Asistencia > 0)
	BEGIN

		--IF (@Id_Sector_Deseado IN (2,7)) //Incluir Sectores
		--BEGIN
			SET @Entrada = (SELECT COUNT(*) FROM CD_ES
							WHERE FECHA BETWEEN (SELECT DATEADD(HOUR,-@Horas_Asistencia,GETDATE()))
							and GETDATE()
							AND Tipo='E'
							AND Id_Cliente=@pId_Cliente)

				IF @Entrada = 0
				BEGIN
					SET @Respuesta = 'De acuerdo a las reglas de reserva de las canchas, ud no puede realizar la misma por no encontrarse dentro de la institución en el rango de tiempo solicitado'
					RETURN @Respuesta
				END
			
				--Acompañante 
				SET @Entrada = (SELECT COUNT(*) 
										FROM CRM_Turnos_Clientes TC , CD_ES CD , CRM_Turnos T
										WHERE 
										T.Id_Turno=TC.Id_Turno
										AND TC.Id_Cliente=CD.Id_Cliente
										AND TC.Id_Cliente = @pId_Cliente
										and T.fecha = @Fecha
										AND CD.FECHA BETWEEN (SELECT DATEADD(HOUR,-@Horas_Asistencia,GETDATE()))
										and GETDATE()
										AND Tipo='E'
										)
						
				IF(@Entrada = 0)
				BEGIN
					SET @Respuesta = 'De acuerdo a las reglas de reserva de las canchas, '+ @Socio +' no puede realizar la misma por no encontrarse dentro de la institución en el rango de tiempo solicitado'
					RETURN @Respuesta
				END

		--END
	END


END
RETURN ISNULL(@Respuesta, '')
END
